<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../helpers.php';

// Handle create
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'add') {
  verify_csrf();
  $name = trim($_POST['name'] ?? '');
  if ($name === '') { $error = 'Name required'; }
  else {
    $stmt = $pdo->prepare("INSERT IGNORE INTO devices(name) VALUES(?)");
    $stmt->execute([$name]);
    redirect('devices.php');
  }
}

// Handle delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'delete') {
  verify_csrf();
  $id = (int)($_POST['id'] ?? 0);
  if ($id > 0) {
    $stmt = $pdo->prepare("DELETE FROM devices WHERE id=?");
    $stmt->execute([$id]);
  }
  redirect('devices.php');
}

$rows = $pdo->query("SELECT * FROM devices ORDER BY name ASC")->fetchAll();
include __DIR__.'/header.php';
?>
<div class="card">
  <h2>Devices</h2>
  <form method="post" class="form-row" style="align-items:end;">
    <input type="hidden" name="action" value="add">
    <?php csrf_field(); ?>
    <div>
      <label>Name</label>
      <input type="text" name="name" placeholder="e.g., Galaxy A20" required>
    </div>
    <div>
      <button class="btn">Add</button>
    </div>
  </form>
</div>

<div class="card">
  <table class="table">
    <thead><tr><th>ID</th><th>Name</th><th>Created</th><th>Actions</th></tr></thead>
    <tbody>
    <?php foreach ($rows as $r): ?>
      <tr>
        <td><?= e($r['id']) ?></td>
        <td><span class="badge"><?= e($r['name']) ?></span></td>
        <td><?= e($r['created_at']) ?></td>
        <td class="actions">
          <form method="post" onsubmit="return confirmDelete('Delete device?');">
            <?php csrf_field(); ?>
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="<?= e($r['id']) ?>">
            <button class="btn danger">Delete</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php include __DIR__.'/footer.php'; ?>
